package doABC.Cpool;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import FlashReader.SWF;
import FlashReader.SwfTools;

public class StringInfo extends SwfTools{
	
	private int id;	
	private int start=-1;
	private int end=-1;
	
	//struktury
	private int size=-1;
	private ArrayList<Byte> utf8 = new ArrayList<Byte>();
	
	public  StringInfo(String value, int id){
		super();
		setString(value);
		this.id = id;
	}
	
	
	public  StringInfo( ByteBuffer bbuf, int id){
		super();
		string_info(bbuf);
		this.id = id;
	}
	
	
	private void string_info(ByteBuffer bbuf){
		start = bbuf.position();
		
		size = unsigned30int(bbuf);
		
		for (int ii =0;ii<size;ii++)
			utf8.add(bbuf.get());

		end = bbuf.position()-1;
	}

	//getters

	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}

	public String getUtf8_string() {
		 String result = "";
		 for (int i =0 ; i< utf8.size();i++)
			 result +=  "" +((char)utf8.get(i).byteValue());
		return result;
	}
	
	//setters
	public void setString(String s){
		byte b[] = s.getBytes();
		utf8.clear();
		for(int i =0; i < b.length;i++)
			utf8.add(b[i]);
		size =  b.length;
	}
	
	
	
	//toStrings
	
	public String String(){
		String wynik ="";
		wynik+="\n---#--- ns_set_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
		
		wynik+= "size: " + size+"\n";
			
		wynik+= "ns: " + getUtf8_string()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}
	
	public String toString(){
		String wynik ="";
		wynik+=getUtf8_string();
		return wynik;
	}
	

	public int getSize() {
		return size;
	}


	public ArrayList<Byte> getUtf8() {
		return utf8;
	}
	
	public int getId() {
		return id;
	}

	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
		if (  size!=-1){
			for ( byte b : getUI32(size))
				result.add(b);
		}
		
		
		if (  utf8.size()>0){
			for ( byte b : utf8)
				result.add(b);
		}
		
		return result;
	}
	
}
